###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vmware_prdts_mult_vuln_win.nasl 0274 2008-09-23 10:33:04Z sep $
#
# VMCI/HGFS VmWare Code Execution Vulnerability (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800002);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2008-2098", "CVE-2008-2099");
  script_bugtraq_id(29443);
  script_xref(name:"CB-A", value:"08-0087:");
  script_name("VMCI/HGFS VmWare Code Execution Vulnerability (Win)");
  desc = "

  Overview : The host is installed with VMWare product(s) that are vulnerable
  to arbitrary code execution.

  Vulnerability Insight:
  VMCI is an optional feature that allows communication with one another.
  This vulnerability allows the guest systems to execute arbitrary code on
  the host in the context of vmx process. The issue affects Windows based
  VMWare hosts only.

  VMware Host Guest File System (HGFS) shared folders feature allows users
  to transfer data between a guest operating system and the host operating
  system. A heap buffer overflow exists in VMware HGFS which allows guest
  system to execute code in the context of vmx process on the host.
  The issue exists only when VMWare system has shared folder enabled.

  Successful exploitation requires that the vix.inGuest.enable configuration
  value is enabled

  Impact : Successful exploitation allow attackers to execute arbitrary code
  on the affected system and users could bypass certain security restrictions
  or can gain escalated privileges.

  Impact Level : System

  Affected Software/OS:
  VMware ACE/Player 2.0.x - 2.0.3 on all Windows
  VMware Workstation 6.0.x - 6.0.3 on all Windows

  Fix : Upgrade VMware to below versions,
  VMware Workstation 6.0.4 or later.
  www.vmware.com/download/ws/

  VMware Player/ACE 2.0.4 or later.
  www.vmware.com/download/player/
  www.vmware.com/download/ace/

  References:
  http://secunia.com/advisories/30476/
  http://www.vmware.com/security/advisories/VMSA-2008-0008.html

  CVSS Score:
    CVSS Base Score     : 6.0 (AV:N/AC:M/Au:SI/C:P/I:P/A:P)
    CVSS Temporal Score : 4.4
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of VMware Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_vmware_prdts_detect_win.nasl");
  exit(0);
}


if(!get_kb_item("VMware/Win/Installed")){ # Is VMWare installed?
  exit(0);
}

# VMware Player
vmplayerVer = get_kb_item("VMware/Player/Win/Ver");
if(vmplayerVer)
{
  if(ereg(pattern:"^(2\.0\.[0-3])($|\..*)", string:vmplayerVer)){
    security_warning(0);
  }
  exit(0);
}

# VMware Workstation
vmworkstnVer = get_kb_item("VMware/Workstation/Win/Ver");
if(vmworkstnVer)
{
  if(ereg(pattern:"^6\.0(\.[0-3])?$", string:vmworkstnVer)){
    security_warning(0);
  }
  exit(0);
}

# VMware ACE
vmaceVer = get_kb_item("VMware/ACE/Win/Ver");
if(!vmaceVer){
  vmaceVer = get_kb_item("VMware/ACE\Dormant/Win/Ver");
}

if(vmaceVer)
{
  if(ereg(pattern:"^2\.0(\.[0-3])?$", string:vmaceVer)){
    security_warning(0);
  }
}
