###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vmware_prdts_dos_vuln_win.nasl 873 2009-02-03 15:35:21Z feb $
#
# VMware Products vmware-authd Denial of Service Vulnerability (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800410);
  script_version("$Revision: 1.1 $");
  script_cve_id("CVE-2009-0177");
  script_bugtraq_id(33095);
  script_name("VMware Products vmware-authd Denial of Service Vulnerability (Win)");
  desc = "

  Overview : The host is installed with VMWare product(s) that are vulnerable
  to Denial of Service vulnerability.

  Vulnerability Insight:
  VMware product(s) throws an error in the vmware-authd daemon when processing
  overly long strings. This will terminate the vmware-authd process via an
  overly long 'USER' or 'PASS' strings sent to TCP port 912.

  Impact : Successful exploitation will let the attacker deny virtual machines
  access to local users.

  Impact Level : Application

  Affected Software/OS:
  VMware Player version 2.5.1 or prior on Windows.
  VMware Workstation version 6.5.1 or prior on Windows.

  Fix : Solution/Patch not available as on 4th February 2009. For further
  updates refer the below URLs.
  http://www.vmware.com/download/ws
  http://www.vmware.com/download/player

  References:
  http://osvdb.org/51180
  http://milw0rm.com/exploits/7647
  http://secunia.com/advisories/33372
  http://www.vupen.com/english/advisories/2009/0024
  http://securitytracker.com/alerts/2009/Jan/1021512.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of VMware Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_vmware_prdts_detect_win.nasl");
  script_require_keys("SMB/WindowsVersion", "VMware/Win/Installed");
  exit(0);
}


include("version_func.inc");

if(!get_kb_item("VMware/Win/Installed")){
  exit(0);
}

# VMware Player
vmplayerVer = get_kb_item("VMware/Player/Win/Ver");
if(vmplayerVer)
{
  if(version_is_less_equal(version:vmplayerVer, test_version:"2.5.1"))
  {
    security_warning(0);
    exit(0);
  }
}

# VMware Workstation
vmworkstnVer = get_kb_item("VMware/Workstation/Win/Ver");
if(vmworkstnVer)
{
  if(version_is_less_equal(version:vmworkstnVer, test_version:"6.5.1")){
    security_warning(0);
  }
  exit(0);
}
