###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vlc_media_player_ty_bof_vuln_win.nasl 0370 2008-10-22 10:22:02Z oct $
#
# VLC Media Player TY Processing Buffer Overflow Vulnerability (Win)
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800116);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-4654", "CVE-2008-4686");
  script_bugtraq_id(31813);
  script_name("VLC Media Player TY Processing Buffer Overflow Vulnerability (Win)");
  desc = "

  Overview: This host is installed with VLC Media Player and is prone to
  Buffer Overflow Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to a boundary error while parsing the header of an
  invalid TY file.

  Impact: Successful exploitation allows attackers to execute arbitrary code
  by tricking a user into opening a specially crafted TY file or can even
  crash an affected application.

  Impact Level: Application

  Affected Software/OS:
  VLC media player 0.9.0 through 0.9.4 on Windows (Any).

  Fix: Upgrade to Version 0.9.5, or
  Apply the available patch from below link,
  http://git.videolan.org/?p=vlc.git;a=commitdiff;h=26d92b87bba99b5ea2e17b7eaa39c462d65e9133#patch1

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://secunia.com/advisories/32339/
  http://www.videolan.org/security/sa0809.html
  http://www.trapkit.de/advisories/TKADV2008-010.txt
  http://www.frsirt.com/english/advisories/2008/2856

  CVSS Score:
    CVSS Base Score     : 8.3 (AV:N/AC:M/Au:NR/C:P/I:P/A:C)
    CVSS Temporal Score : 6.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of VLC Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

vlcVer = registry_get_sz(item:"Version", key:"SOFTWARE\VideoLAN\VLC");
if(!vlcVer){
  exit(0);
}

# Check for VLC Media Player Version 0.9.0 to 0.9.4
if(version_in_range(version:vlcVer,
                    test_version:"0.9.0", test_version2:"0.9.4")){
  security_hole(0);
}
