###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vlc_media_player_bof_vuln_jul09_win.nasl 3540 2009-07-17 12:52:23Z jul $
#
# VLC Media Player SMB 'Win32AddConnection()' BOF Vulnerability - July09 (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800663);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2484");
  script_bugtraq_id(35500);
  script_name("VLC Media Player SMB 'Win32AddConnection()' BOF Vulnerability - July09 (Win)");
  desc = "

  Overview: This host is installed with VLC Media Player and is prone to
  Stack-Based Buffer Overflow Vulnerability.

  Vulnerability Insight:
  Stack-based Buffer overflow error in the 'Win32AddConnection' function in
  modules/access/smb.c while processing a specially crafted long 'smb://' URI
  within a playlist.

  Impact:
  Successful exploitation allows attackers to execute arbitrary code, and can
  casue application crash.

  Impact Level: Application

  Affected Software/OS:
  VLC Media Player version 0.9.9 and prior on Windows.

  Fix: Apply the available patch from below link,
  http://git.videolan.org/?p=vlc.git;a=commit;h=e60a9038b13b5eb805a76755efc5c6d5e080180f

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://secunia.com/advisories/35558
  http://www.milw0rm.com/exploits/9029
  http://www.vupen.com/english/advisories/2009/1714

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.6
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of VLC Media Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("secpod_vlc_media_player_detect_win.nasl");
  script_require_keys("VLCPlayer/Win/Ver");
  script_require_ports("Services/www", 135, 445);
  exit(0);
}


include("version_func.inc");

vlcVer = get_kb_item("VLCPlayer/Win/Ver");
if(vlcVer != NULL)
{
  if(version_is_less_equal(version:vlcVer, test_version:"0.9.9")){
    security_hole(0);
  }
}
