###############################################################################
# Openvas Vulnerability Test
# $Id: gb_visualization_library_mult_vuln_win.nasl 7616 2010-03-12 17:50:35z mar $
#
# Visualization Library Multiple Unspecified Vulnerabilities (Windows)
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(801000);
  script_version("$Revision: 6992 $: 1.0");
  script_cve_id("CVE-2010-0937");
  script_bugtraq_id(37644);
  script_name("Visualization Library Multiple Unspecified Vulnerabilities (Windows)");
  desc = "
  Overview: The host is running Visualization Library and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  The flaws are caused by multiple unspecified errors with unknown impact and
  unknown attack vectors.

  Impact:
  Unknown impacts and unknown attack vectors.

  Impact Level: Application

  Affected Software/OS:
  Visualization Library versions prior to 2009.08.812 on Windows

  Fix: Update to version 2009.08.812 or above,
  For updates refer, http://www.visualizationlibrary.com/downloads.php

  References:
  http://xforce.iss.net/xforce/xfdb/55478
  http://www.vupen.com/english/advisories/2010/0050
  http://visualizationlibrary.com/documentation/pagchangelog.html

  CVSS Score:
    CVSS Base Score      : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.4
  Risk factor : High";

  script_description(desc);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_summary("Check for the version of Visualization Library");
  script_category(ACT_GATHER_INFO);
  script_family("General");
  script_dependencies("gb_visualization_library_detect_win.nasl");
  script_require_keys("VisualizationLibrary/Win/Ver");
  exit(0);
}


include("version_func.inc");

## Get Visualization Library version from KB
vslVer = get_kb_item("VisualizationLibrary/Win/Ver");
if(isnull(vslVer)){
  exit(0);
}

## Check for versions prior to  2009.08.812
if(version_is_less(version:vslVer, test_version:"2009.08.812")){
  security_hole(0);
}
