###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_v-webmail_detect.nasl 3220 2009-07-02 19:48:24Z jul $
#
# V-webmail Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800821);
  script_version("Revision: 1.0");
  script_name("V-webmail Version Detection");
  desc = "

  Overview: This script detects the installed version of V-webmail and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set Version of V-webmail in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes", "http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

vwmailPort = get_http_port(default:80);
if(!vwmailPort){
  vwmailPort = 80;
}

if(!get_port_state(vwmailPort)){
  exit(0);
}

foreach dir (make_list ("/", "/v-webmail", "/webmail", cgi_dirs()))
{
  sndReq = http_get(item:dir + "/htdocs/login.php", port:vwmailPort);
  rcvRes = http_send_recv(data:sndReq, port:vwmailPort);

  if(rcvRes =~ "<title>V-webmail [0-9.]+</title>" &&
     egrep(pattern:"^HTTP/.* 200 OK", string:rcvRes))
  {
    vwmailVer = eregmatch(pattern:"V-webmail ([0-9]\.[0-9]\.[0-9])",
                          string:rcvRes);
    if(vwmailVer[1] != NULL)
    {
      set_kb_item(name:"www/" + vwmailPort + "/V-webmail",
                  value:vwmailVer[1] + " under " + dir);
    }
  }
}
