###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for moin vulnerabilities USN-911-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840400);
  script_version("$Revision: 6957 $: 1.0");
  script_xref(name: "USN", value: "911-1");
  script_cve_id("CVE-2010-0668", "CVE-2010-0669", "CVE-2010-0717");
  script_name("Ubuntu Update for moin vulnerabilities USN-911-1");
  desc = "

  Vulnerability Insight:

  It was discovered that several wiki actions and preference settings in
  MoinMoin were not protected from cross-site request forgery (CSRF). If an
  authenticated user were tricked into visiting a malicious website while
  logged into MoinMoin, a remote attacker could change the user's
  configuration or wiki content. (CVE-2010-0668, CVE-2010-0717)
  
  It was discovered that MoinMoin did not properly sanitize its input when
  processing user preferences. An attacker could enter malicious content
  which when viewed by a user, could render in unexpected ways.
  (CVE-2010-0669)

  Affected Software/OS:
  moin vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-March/001059.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of moin vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.8.2-2ubuntu2.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"moinmoin-common", ver:"1.5.2-1ubuntu2.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.5.2-1ubuntu2.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python2.4-moinmoin", ver:"1.5.2-1ubuntu2.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.7.1-1ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"moinmoin-common", ver:"1.5.8-5.1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.5.8-5.1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"python-moinmoin", ver:"1.8.4-1ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}