###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for openoffice.org vulnerabilities USN-903-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840394);
  script_version("$Revision: 6863 $: 1.0");
  script_xref(name: "USN", value: "903-1");
  script_cve_id("CVE-2009-0217", "CVE-2009-2949", "CVE-2009-2950", "CVE-2009-3301", "CVE-2009-3302", "CVE-2010-0136");
  script_name("Ubuntu Update for openoffice.org vulnerabilities USN-903-1");
  desc = "

  Vulnerability Insight:

  It was discovered that the XML HMAC signature system did not
  correctly check certain lengths. If an attacker sent a truncated
  HMAC, it could bypass authentication, leading to potential privilege
  escalation. (CVE-2009-0217)
  
  Sebastian Apelt and Frank Rei&#223;ner discovered that OpenOffice did not
  correctly import XPM and GIF images.  If a user were tricked into opening
  a specially crafted image, an attacker could execute arbitrary code with
  user privileges. (CVE-2009-2949, CVE-2009-2950)
  
  Nicolas Joly discovered that OpenOffice did not correctly handle
  certain Word documents.  If a user were tricked into opening a specially
  crafted document, an attacker could execute arbitrary code with user
  privileges. (CVE-2009-3301, CVE-2009-3302)
  
  It was discovered that OpenOffice did not correctly handle certain
  VBA macros correctly.  If a user were tricked into opening a specially
  crafted document, an attacker could execute arbitrary macro commands,
  bypassing security controls. (CVE-2010-0136)

  Affected Software/OS:
  openoffice.org vulnerabilities on Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-February/001051.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openoffice.org vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"libmythes-dev", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-base-core", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-base", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-calc", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-core", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-draw", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-evolution", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-binfilter", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gcj", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gnome", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gtk", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-impress", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-kde", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-math", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-officebean", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-report-builder-bin", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-writer", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-uno", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"uno-libs3-dbg", ver:"1.4.1+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"uno-libs3", ver:"1.4.1+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ure-dbg", ver:"1.4.1+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ure", ver:"1.4.1+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cli-uno-bridge", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-openoffice.org", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-kab", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-pdfimport", ver:"0.3.2+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-presentation-minimizer", ver:"1.0+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-presenter-console", ver:"1.0+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-sdbc-postgresql", ver:"0.7.6+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-common", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev-doc", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-emailmerge", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-mobiledev", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-java-common", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-in", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-za", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-andromeda", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-crystal", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-galaxy", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-human", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-industrial", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-tango", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ttf-opensymbol", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"broffice.org", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-basetypes1.0-cil", ver:"1.0.12.0+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-cppuhelper1.0-cil", ver:"1.0.15.0+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-oootypes1.0-cil", ver:"1.0.1.0+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-ure1.0-cil", ver:"1.0.15.0+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-uretypes1.0-cil", ver:"1.0.1.0+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dtd-officedocument1.0", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-report-builder", ver:"1.0.5+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-hicontrast", ver:"3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-wiki-publisher", ver:"1.0+OOo3.0.1-9ubuntu3.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"libmythes-dev", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-base-core", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-base", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-calc", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-core", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-draw", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-evolution", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-binfilter", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gcj", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gnome", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gtk", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-impress", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-kde", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-math", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-officebean", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-report-builder-bin", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-writer", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-uno", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ure-dbg", ver:"1.4+OOo2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ure", ver:"1.4+OOo2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cli-uno-bridge", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-openoffice.org", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-headless", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-ogltrans", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-presentation-minimizer", ver:"1.0+OOo2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-qa-tools", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-sdbc-postgresql", ver:"0.7.5+OOo2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-common", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev-doc", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-emailmerge", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-mobiledev", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-java-common", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-in", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-za", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-andromeda", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-crystal", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-human", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-industrial", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-tango", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ttf-opensymbol", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"broffice.org", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-basetypes1.0-cil", ver:"1.0.10.0+OOo2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-cppuhelper1.0-cil", ver:"1.0.13.0+OOo2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-types1.1-cil", ver:"1.1.13.0+OOo2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-ure1.0-cil", ver:"1.0.13.0+OOo2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dtd-officedocument1.0", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-qa-api-tests", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-report-builder", ver:"1.0.2+OOo2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-hicontrast", ver:"2.4.1-11ubuntu2.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libmythes-dev", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cil", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-base-core", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-base", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-calc", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-core", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-draw", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-evolution", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-binfilter", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gcj", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gnome", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gtk", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-impress", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-kde", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-math", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-officebean", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-qa-tools", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-writer", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-uno", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ure-dbg", ver:"1.4+OOo2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ure", ver:"1.4+OOo2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-openoffice.org", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-headless", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-ogltrans", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-presentation-minimizer", ver:"1.0+OOo2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-report-builder", ver:"1.0.2+OOo2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-sdbc-postgresql", ver:"0.7.5+OOo2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-common", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev-doc", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-mobiledev", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-java-common", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-in", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-za", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-qa-api-tests", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-andromeda", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-crystal", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-human", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-industrial", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-tango", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ttf-opensymbol", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"broffice.org", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dtd-officedocument1.0", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-hicontrast", ver:"2.4.1-1ubuntu2.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"libmythes-dev", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-base-core", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-base", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-calc", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-core", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-draw", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-evolution", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-binfilter", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gcj", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gnome", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-gtk", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-impress", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-kde", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-math", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-officebean", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-report-builder-bin", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-writer", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-uno", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"uno-libs3-dbg", ver:"1.5.1+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"uno-libs3", ver:"1.5.1+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ure-dbg", ver:"1.5.1+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ure", ver:"1.5.1+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"cli-uno-bridge", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-openoffice.org", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-ogltrans", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-pdfimport", ver:"1.0+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-presentation-minimizer", ver:"1.0+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-presenter-console", ver:"1.1.0+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-sdbc-postgresql", ver:"0.7.6+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-common", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dev-doc", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-emailmerge", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-filter-mobiledev", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-java-common", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-in", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-l10n-za", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-andromeda", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-galaxy", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-human", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-industrial", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-oxygen", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-tango", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ttf-opensymbol", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"broffice.org", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-basetypes1.0-cil", ver:"1.0.14.0+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-cppuhelper1.0-cil", ver:"1.0.17.0+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-oootypes1.0-cil", ver:"1.0.3.0+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-ure1.0-cil", ver:"1.0.17.0+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libuno-cli-uretypes1.0-cil", ver:"1.0.3.0+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-dtd-officedocument1.0", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-report-builder", ver:"1.1.0+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-crystal", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-style-hicontrast", ver:"3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openoffice.org-wiki-publisher", ver:"1.0+OOo3.1.1-5ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}