###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for ruby1.9 vulnerabilities USN-900-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840389);
  script_version("$Revision: 6790 $: 1.0");
  script_xref(name: "USN", value: "900-1");
  script_cve_id("CVE-2009-1904", "CVE-2009-4124", "CVE-2009-4492");
  script_name("Ubuntu Update for ruby1.9 vulnerabilities USN-900-1");
  desc = "

  Vulnerability Insight:

  Emmanouel Kellinis discovered that Ruby did not properly handle certain
  string operations. An attacker could exploit this issue and possibly
  execute arbitrary code with application privileges. (CVE-2009-4124)
  
  Giovanni Pellerano, Alessandro Tanasi, and Francesco Ongaro discovered that
  Ruby did not properly sanitize data written to log files. An attacker could
  insert specially-crafted data into log files which could affect certain
  terminal emulators and cause arbitrary files to be overwritten, or even
  possibly execute arbitrary commands. (CVE-2009-4492)
  
  It was discovered that Ruby did not properly handle string arguments that
  represent large numbers. An attacker could exploit this and cause a denial
  of service. This issue only affected Ubuntu 9.10. (CVE-2009-1904)

  Affected Software/OS:
  ruby1.9 vulnerabilities on Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-February/001045.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of ruby1.9 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"libruby1.9-dbg", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libruby1.9", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9-dev", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbm-ruby1.9", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgdbm-ruby1.9", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libopenssl-ruby1.9", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libreadline-ruby1.9", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libtcltk-ruby1.9", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"irb1.9", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"rdoc1.9", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ri1.9", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9-elisp", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9-examples", ver:"1.9.0.5-1ubuntu1.2", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"libruby1.9-dbg", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libruby1.9", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9-dev", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbm-ruby1.9", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgdbm-ruby1.9", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libopenssl-ruby1.9", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libreadline-ruby1.9", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libtcltk-ruby1.9", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"irb1.9", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"rdoc1.9", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ri1.9", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9-elisp", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9-examples", ver:"1.9.0.2-9ubuntu1.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"libruby1.9-dbg", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libruby1.9", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9-dev", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdbm-ruby1.9", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgdbm-ruby1.9", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libopenssl-ruby1.9", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libreadline-ruby1.9", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libtcltk-ruby1.9", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"irb1.9", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"rdoc1.9", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ri1.9", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9-elisp", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ruby1.9-examples", ver:"1.9.0.2-7ubuntu1.3", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}