###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for gnome-screensaver vulnerability USN-898-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840385);
  script_version("$Revision: 6743 $: 1.0");
  script_xref(name: "USN", value: "898-1");
  script_cve_id("CVE-2010-0414");
  script_name("Ubuntu Update for gnome-screensaver vulnerability USN-898-1");
  desc = "

  Vulnerability Insight:

  It was discovered that gnome-screensaver did not correctly handle monitor
  hotplugging. An attacker with physical access could cause gnome-screensaver
  to crash and gain access to the locked session.

  Affected Software/OS:
  gnome-screensaver vulnerability on Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-February/001043.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gnome-screensaver vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"gnome-screensaver", ver:"2.28.0-0ubuntu3.4", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}