###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for MySQL vulnerabilities USN-897-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840384);
  script_version("$Revision: 6743 $: 1.0");
  script_xref(name: "USN", value: "897-1");
  script_cve_id("CVE-2008-4098", "CVE-2008-4456", "CVE-2008-7247", "CVE-2009-2446", "CVE-2009-4019", "CVE-2009-4030", "CVE-2009-4484");
  script_name("Ubuntu Update for MySQL vulnerabilities USN-897-1");
  desc = "

  Vulnerability Insight:

  It was discovered that MySQL could be made to overwrite existing table
  files in the data directory. An authenticated user could use the DATA
  DIRECTORY and INDEX DIRECTORY options to possibly bypass privilege checks.
  This update alters table creation behaviour by disallowing the use of the
  MySQL data directory in DATA DIRECTORY and INDEX DIRECTORY options. This
  issue only affected Ubuntu 8.10. (CVE-2008-4098)
  
  It was discovered that MySQL contained a cross-site scripting vulnerability
  in the command-line client when the --html option is enabled. An attacker
  could place arbitrary web script or html in a database cell, which would
  then get placed in the html document output by the command-line tool. This
  issue only affected Ubuntu 6.06 LTS, 8.04 LTS, 8.10 and 9.04.
  (CVE-2008-4456)
  
  It was discovered that MySQL could be made to overwrite existing table
  files in the data directory. An authenticated user could use symlinks
  combined with the DATA DIRECTORY and INDEX DIRECTORY options to possibly
  bypass privilege checks. This issue only affected Ubuntu 9.10.
  (CVE-2008-7247)
  
  It was discovered that MySQL contained multiple format string flaws when
  logging database creation and deletion. An authenticated user could use
  specially crafted database names to make MySQL crash, causing a denial of
  service. This issue only affected Ubuntu 6.06 LTS, 8.04 LTS, 8.10 and 9.04.
  (CVE-2009-2446)
  
  It was discovered that MySQL incorrectly handled errors when performing
  certain SELECT statements, and did not preserve correct flags when
  performing statements that use the GeomFromWKB function. An authenticated
  user could exploit this to make MySQL crash, causing a denial of service.
  (CVE-2009-4019)
  
  It was discovered that MySQL incorrectly checked symlinks when using the
  DATA DIRECTORY and INDEX DIRECTORY options. A local user could use symlinks
  to create tables that pointed to tables known to be created at a later
  time, bypassing access restrictions. (CVE-2009-4030)
  
  It was discovered that MySQL contained a buffer overflow when parsing
  ssl certificates. A remote attacker could send crafted requests and cause a
  denial of service or possibly execute arbitrary code. This issue did not
  affect Ubuntu 6.06 LTS and the default compiler options for affected
  releases should reduce the vulnerability to a denial of service. In the
  default installation, attackers would also be isolated by the AppArmor
  MySQL profile. (CVE-2009-4484)

  Affected Software/OS:
  MySQL vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-February/001042.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of MySQL vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.1.30really5.0.75-0ubuntu10.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.1.30really5.0.75-0ubuntu10.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client-5.0", ver:"5.1.30really5.0.75-0ubuntu10.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server-5.0", ver:"5.1.30really5.0.75-0ubuntu10.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server-core-5.0", ver:"5.1.30really5.0.75-0ubuntu10.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.1.30really5.0.75-0ubuntu10.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-common", ver:"5.1.30really5.0.75-0ubuntu10.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.1.30really5.0.75-0ubuntu10.3", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.22-0ubuntu6.06.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.22-0ubuntu6.06.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client-5.0", ver:"5.0.22-0ubuntu6.06.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server-5.0", ver:"5.0.22-0ubuntu6.06.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.22-0ubuntu6.06.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.22-0ubuntu6.06.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.22-0ubuntu6.06.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.67-0ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.67-0ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client-5.0", ver:"5.0.67-0ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server-5.0", ver:"5.0.67-0ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.67-0ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.67-0ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.67-0ubuntu6.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libmysqlclient15-dev", ver:"5.0.51a-3ubuntu5.5", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqlclient15off", ver:"5.0.51a-3ubuntu5.5", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client-5.0", ver:"5.0.51a-3ubuntu5.5", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server-5.0", ver:"5.0.51a-3ubuntu5.5", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.0.51a-3ubuntu5.5", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-common", ver:"5.0.51a-3ubuntu5.5", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.0.51a-3ubuntu5.5", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"libmysqlclient-dev", ver:"5.1.37-1ubuntu5.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqlclient16", ver:"5.1.37-1ubuntu5.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqld-dev", ver:"5.1.37-1ubuntu5.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqld-pic", ver:"5.1.37-1ubuntu5.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client-5.1", ver:"5.1.37-1ubuntu5.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server-5.1", ver:"5.1.37-1ubuntu5.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server-core-5.1", ver:"5.1.37-1ubuntu5.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libmysqlclient16-dev", ver:"5.1.37-1ubuntu5.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-client", ver:"5.1.37-1ubuntu5.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-common", ver:"5.1.37-1ubuntu5.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mysql-server", ver:"5.1.37-1ubuntu5.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}