###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for gimp vulnerabilities USN-880-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840362);
  script_version("$Revision: 6414 $: 1.0");
  script_xref(name: "USN", value: "880-1");
  script_cve_id("CVE-2009-1570", "CVE-2009-3909");
  script_name("Ubuntu Update for gimp vulnerabilities USN-880-1");
  desc = "

  Vulnerability Insight:

  Stefan Cornelius discovered that GIMP did not correctly handle certain
  malformed BMP files. If a user were tricked into opening a specially
  crafted BMP file, an attacker could execute arbitrary code with the user's
  privileges. (CVE-2009-1570)
  
  Stefan Cornelius discovered that GIMP did not correctly handle certain
  malformed PSD files. If a user were tricked into opening a specially
  crafted PSD file, an attacker could execute arbitrary code with the user's
  privileges. This issue only applied to Ubuntu 8.10, 9.04 and 9.10.
  (CVE-2009-3909)

  Affected Software/OS:
  gimp vulnerabilities on Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001020.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gimp vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"gimp-dbg", ver:"2.6.6-0ubuntu1.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gimp", ver:"2.6.6-0ubuntu1.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgimp2.0-dev", ver:"2.6.6-0ubuntu1.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgimp2.0", ver:"2.6.6-0ubuntu1.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gimp-data", ver:"2.6.6-0ubuntu1.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgimp2.0-doc", ver:"2.6.6-0ubuntu1.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"gimp-dbg", ver:"2.6.1-1ubuntu3.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gimp", ver:"2.6.1-1ubuntu3.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgimp2.0-dev", ver:"2.6.1-1ubuntu3.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgimp2.0", ver:"2.6.1-1ubuntu3.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gimp-data", ver:"2.6.1-1ubuntu3.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgimp2.0-doc", ver:"2.6.1-1ubuntu3.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"gimp-dbg", ver:"2.4.5-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gimp-gnomevfs", ver:"2.4.5-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gimp-python", ver:"2.4.5-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gimp", ver:"2.4.5-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgimp2.0-dev", ver:"2.4.5-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgimp2.0", ver:"2.4.5-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gimp-libcurl", ver:"2.4.5-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gimp-data", ver:"2.4.5-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgimp2.0-doc", ver:"2.4.5-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"gimp-dbg", ver:"2.6.7-1ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gimp", ver:"2.6.7-1ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgimp2.0-dev", ver:"2.6.7-1ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgimp2.0", ver:"2.6.7-1ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gimp-data", ver:"2.6.7-1ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libgimp2.0-doc", ver:"2.6.7-1ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}