###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for dhcp3 vulnerability USN-803-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840379);
  script_version("$Revision: 6589 $: 1.0");
  script_xref(name: "USN", value: "803-2");
  script_cve_id("CVE-2009-0692");
  script_name("Ubuntu Update for dhcp3 vulnerability USN-803-2");
  desc = "

  Vulnerability Insight:

  USN-803-1 fixed a vulnerability in Dhcp. Due to an error, the patch to
  fix the vulnerability was not properly applied on Ubuntu 8.10 and higher.
  Even with the patch improperly applied, the default compiler options
  reduced the vulnerability to a denial of service. Additionally, in Ubuntu
  9.04 and higher, users were also protected by the AppArmor dhclient3
  profile. This update fixes the problem.
  
  Original advisory details:
  
  It was discovered that the DHCP client as included in dhcp3 did not verify
  the length of certain option fields when processing a response from an IPv4
  dhcp server. If a user running Ubuntu 6.06 LTS or 8.04 LTS connected to a
  malicious dhcp server, a remote attacker could cause a denial of service or
  execute arbitrary code as the user invoking the program, typically the
  'dhcp' user. For users running Ubuntu 8.10 or 9.04, a remote attacker
  should only be able to cause a denial of service in the DHCP client. In
  Ubuntu 9.04, attackers would also be isolated by the AppArmor dhclient3
  profile.

  Affected Software/OS:
  dhcp3 vulnerability on Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001037.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of dhcp3 vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"dhcp3-client", ver:"3.1.2-1ubuntu7.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-common", ver:"3.1.2-1ubuntu7.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-dev", ver:"3.1.2-1ubuntu7.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-server", ver:"3.1.2-1ubuntu7.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-relay", ver:"3.1.2-1ubuntu7.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-server-ldap", ver:"3.1.2-1ubuntu7.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp-client", ver:"3.1.2-1ubuntu7.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"dhcp3-client", ver:"3.1.1-5ubuntu8.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-common", ver:"3.1.1-5ubuntu8.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-dev", ver:"3.1.1-5ubuntu8.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-server", ver:"3.1.1-5ubuntu8.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-relay", ver:"3.1.1-5ubuntu8.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-server-ldap", ver:"3.1.1-5ubuntu8.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp-client", ver:"3.1.1-5ubuntu8.2", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"dhcp3-client", ver:"3.1.1-1ubuntu2.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-common", ver:"3.1.1-1ubuntu2.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-dev", ver:"3.1.1-1ubuntu2.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-server", ver:"3.1.1-1ubuntu2.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-relay", ver:"3.1.1-1ubuntu2.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"dhcp3-server-ldap", ver:"3.1.1-1ubuntu2.2", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}