###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for exiv2 vulnerabilities USN-655-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840274);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "655-1");
  script_cve_id("CVE-2007-6353", "CVE-2008-2696");
  script_name( "Ubuntu Update for exiv2 vulnerabilities USN-655-1");
  desc = "

  Vulnerability Insight:

  Meder Kydyraliev discovered that exiv2 did not correctly handle certain
  EXIF headers. If a user or automated system were tricked into processing
  a specially crafted image, a remote attacker could cause the application
  linked against libexiv2 to crash, leading to a denial of service, or
  possibly executing arbitrary code with user privileges. (CVE-2007-6353)
  
  Joakim Bildrulle discovered that exiv2 did not correctly handle Nikon
  lens EXIF information.  If a user or automated system were tricked into
  processing a specially crafted image, a remote attacker could cause the
  application linked against libexiv2 to crash, leading to a denial of
  service. (CVE-2008-2696)

  Affected Software/OS:
  exiv2 vulnerabilities on Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-October/000763.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of exiv2 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libexiv2", ver:"0.12_0.12-0ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexiv2-dev", ver:"0.12-0ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"exiv2", ver:"0.12-0ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexiv2-doc", ver:"0.12-0ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libexiv2-2", ver:"0.16-3ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexiv2-dev", ver:"0.16-3ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"exiv2", ver:"0.16-3ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexiv2-doc", ver:"0.16-3ubuntu1.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libexiv2-0", ver:"0.15-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexiv2-dev", ver:"0.15-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"exiv2", ver:"0.15-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libexiv2-doc", ver:"0.15-1ubuntu2.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}