###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for openssh vulnerabilities USN-649-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840259);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "649-1");
  script_cve_id("CVE-2008-1657", "CVE-2008-4109");
  script_name( "Ubuntu Update for openssh vulnerabilities USN-649-1");
  desc = "

  Vulnerability Insight:

  It was discovered that the ForceCommand directive could be bypassed.
  If a local user created a malicious ~/.ssh/rc file, they could execute
  arbitrary commands as their user id.  This only affected Ubuntu 7.10.
  (CVE-2008-1657)
  
  USN-355-1 fixed vulnerabilities in OpenSSH.  It was discovered that the
  fixes for this issue were incomplete.  A remote attacker could attempt
  multiple logins, filling all available connection slots, leading to a
  denial of service.  This only affected Ubuntu 6.06 and 7.04.
  (CVE-2008-4109)

  Affected Software/OS:
  openssh vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-October/000757.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openssh vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"openssh-client", ver:"4.2p1-7ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssh-server", ver:"4.2p1-7ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh-askpass-gnome", ver:"4.2p1-7ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh", ver:"4.2p1-7ubuntu3.5", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"openssh-client", ver:"4.3p2-8ubuntu1.5", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssh-server", ver:"4.3p2-8ubuntu1.5", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh-askpass-gnome", ver:"4.3p2-8ubuntu1.5", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh", ver:"4.3p2-8ubuntu1.5", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh-krb5", ver:"4.3p2-8ubuntu1.5", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"openssh-client", ver:"4.6p1-5ubuntu0.6", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"openssh-server", ver:"4.6p1-5ubuntu0.6", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh-askpass-gnome", ver:"4.6p1-5ubuntu0.6", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh", ver:"4.6p1-5ubuntu0.6", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ssh-krb5", ver:"4.6p1-5ubuntu0.6", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}