###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for php5 vulnerabilities USN-628-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840283);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "628-1");
  script_cve_id("CVE-2007-4782", "CVE-2007-4850", "CVE-2007-5898", "CVE-2007-5899", "CVE-2008-0599", "CVE-2008-1384", "CVE-2008-2050", "CVE-2008-2051", "CVE-2008-2107", "CVE-2008-2108", "CVE-2008-2371", "CVE-2008-2829");
  script_name( "Ubuntu Update for php5 vulnerabilities USN-628-1");
  desc = "

  Vulnerability Insight:

  It was discovered that PHP did not properly check the length of the
  string parameter to the fnmatch function. An attacker could cause a
  denial of service in the PHP interpreter if a script passed untrusted
  input to the fnmatch function. (CVE-2007-4782)
  
  Maksymilian Arciemowicz discovered a flaw in the cURL library that
  allowed safe_mode and open_basedir restrictions to be bypassed. If a
  PHP application were tricked into processing a bad file:// request,
  an attacker could read arbitrary files. (CVE-2007-4850)
  
  Rasmus Lerdorf discovered that the htmlentities and htmlspecialchars
  functions did not correctly stop when handling partial multibyte
  sequences. A remote attacker could exploit this to read certain areas
  of memory, possibly gaining access to sensitive information. This
  issue affects Ubuntu 8.04 LTS, and an updated fix is included for
  Ubuntu 6.06 LTS, 7.04 and 7.10. (CVE-2007-5898)
  
  It was discovered that the output_add_rewrite_var function would
  sometimes leak session id information to forms targeting remote URLs.
  Malicious remote sites could use this information to gain access to a
  PHP application user's login credentials. This issue only affects
  Ubuntu 8.04 LTS. (CVE-2007-5899)
  
  It was discovered that PHP did not properly calculate the length of
  PATH_TRANSLATED. If a PHP application were tricked into processing
  a malicious URI, and attacker may be able to execute arbitrary code
  with application privileges. (CVE-2008-0599)
  
  An integer overflow was discovered in the php_sprintf_appendstring
  function. Attackers could exploit this to cause a denial of service.
  (CVE-2008-1384)
  
  Andrei Nigmatulin discovered stack-based overflows in the FastCGI SAPI
  of PHP. An attacker may be able to leverage this issue to perform
  attacks against PHP applications. (CVE-2008-2050)
  
  It was discovered that the escapeshellcmd did not properly process
  multibyte characters. An attacker may be able to bypass quoting
  restrictions and possibly execute arbitrary code with application
  privileges. (CVE-2008-2051)
  
  It was discovered that the GENERATE_SEED macro produced a predictable
  seed under certain circumstances. Attackers may by able to easily
  predict the results of the rand and mt_rand functions.
  (CVE-2008-2107, CVE-2008-2108)
  
  Tavis Ormandy discovered that the PCRE library did not correctly
  handle certain in-pattern options. An attacker could cause PHP
  applications using pcre to crash, leading to a denial of service.
  USN-624-1 fixed vulnerabilities in  ... 

  Description truncated, for more information please check the Reference URL

  Affected Software/OS:
  php5 vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 7.04 ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-July/000731.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of php5 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cgi", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cli", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-common", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-curl", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-dev", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-gd", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-ldap", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mhash", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysql", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysqli", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-odbc", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-recode", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-snmp", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sybase", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xsl", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php-pear", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5", ver:"5.1.2-1ubuntu3.12", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-common", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php-pear", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5", ver:"5.2.1-0ubuntu1.6", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-common", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-gmp", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php-pear", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5", ver:"5.2.4-2ubuntu5.3", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-common", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php-pear", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"php5", ver:"5.2.3-1ubuntu6.4", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}