###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for linux-source-2.6.15 vulnerabilities USN-578-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840330);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "578-1");
  script_cve_id("CVE-2006-6058", "CVE-2006-7229", "CVE-2007-4133", "CVE-2007-4997", "CVE-2007-5093", "CVE-2007-5500", "CVE-2007-6063", "CVE-2007-6151", "CVE-2007-6206", "CVE-2007-6417", "CVE-2008-0001");
  script_name( "Ubuntu Update for linux-source-2.6.15 vulnerabilities USN-578-1");
  desc = "

  Vulnerability Insight:

  The minix filesystem did not properly validate certain filesystem
  values. If a local attacker could trick the system into attempting
  to mount a corrupted minix filesystem, the kernel could be made to
  hang for long periods of time, resulting in a denial of service.
  (CVE-2006-6058)
  
  Alexander Schulze discovered that the skge driver does not properly
  use the spin_lock and spin_unlock functions. Remote attackers could
  exploit this by sending a flood of network traffic and cause a denial
  of service (crash). (CVE-2006-7229)
  
  Hugh Dickins discovered that hugetlbfs performed certain prio_tree
  calculations using HPAGE_SIZE instead of PAGE_SIZE. A local user
  could exploit this and cause a denial of service via kernel panic.
  (CVE-2007-4133)
  
  Chris Evans discovered an issue with certain drivers that use the
  ieee80211_rx function. Remote attackers could send a crafted 802.11
  frame and cause a denial of service via crash. (CVE-2007-4997)
  
  Alex Smith discovered an issue with the pwc driver for certain webcam
  devices. A local user with physical access to the system could remove
  the device while a userspace application had it open and cause the USB
  subsystem to block. (CVE-2007-5093)
  
  Scott James Remnant discovered a coding error in ptrace. Local users
  could exploit this and cause the kernel to enter an infinite loop.
  (CVE-2007-5500)
  
  Venustech AD-LAB discovered a buffer overflow in the isdn net
  subsystem. This issue is exploitable by local users via crafted input
  to the isdn_ioctl function. (CVE-2007-6063)
  
  It was discovered that the isdn subsystem did not properly check for
  NULL termination when performing ioctl handling. A local user could
  exploit this to cause a denial of service. (CVE-2007-6151)
  
  Blake Frantz discovered that when a root process overwrote an existing
  core file, the resulting core file retained the previous core file's
  ownership. Local users could exploit this to gain access to sensitive
  information. (CVE-2007-6206)
  
  Hugh Dickins discovered the when using the tmpfs filesystem, under
  rare circumstances, a kernel page may be improperly cleared. A local
  user may be able to exploit this and read sensitive kernel data or
  cause a denial of service via crash. (CVE-2007-6417)
  
  Bill Roman discovered that the VFS subsystem did not properly check
  access modes. A local user may be able to gain removal privileges
  on directories. (CVE-2008-0001)

  Affected Software/OS:
  linux-source-2.6.15 vulnerabilities on Ubuntu 6.06 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-February/000665.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of linux-source-2.6.15 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-51-386_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-51-686_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-51-k7_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-51-server-bigiron_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-51-server_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers", ver:"2.6.15-51_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-51-386_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-51-686_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-51-k7_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-51-server-bigiron_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image", ver:"2.6.15-51-server_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.15_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source", ver:"2.6.15_2.6.15-51.66", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}