###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for pidgin vulnerability USN-548-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840053);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "548-1");
  script_cve_id("CVE-2007-4999");
  script_name( "Ubuntu Update for pidgin vulnerability USN-548-1");
  desc = "

  Vulnerability Insight:

  It was discovered that Pidgin did not correctly handle certain logging
  events.  A remote attacker could send specially crafted messages and cause
  the application to crash, leading to a denial of service.

  Affected Software/OS:
  pidgin vulnerability on Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-November/000630.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of pidgin vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"finch", ver:"2.2.1-1ubuntu4.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple0", ver:"2.2.1-1ubuntu4.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dbg", ver:"2.2.1-1ubuntu4.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin", ver:"2.2.1-1ubuntu4.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"finch-dev", ver:"2.2.1-1ubuntu4.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-bin", ver:"2.2.1-1ubuntu4.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpurple-dev", ver:"2.2.1-1ubuntu4.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-data", ver:"2.2.1-1ubuntu4.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pidgin-dev", ver:"2.2.1-1ubuntu4.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"gaim", ver:"2.2.1-1ubuntu4.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}