###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for libnet-dns-perl vulnerabilities USN-483-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840172);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "483-1");
  script_cve_id("CVE-2007-3377", "CVE-2007-3409");
  script_name( "Ubuntu Update for libnet-dns-perl vulnerabilities USN-483-1");
  desc = "

  Vulnerability Insight:

  Peter Johannes Holzer discovered that the Net::DNS Perl module had
  predictable sequence numbers.  This could allow remote attackers to
  carry out DNS spoofing, leading to possible man-in-the-middle attacks.
  (CVE-2007-3377)
  
  Steffen Ullrich discovered that the Net::DNS Perl module did not correctly
  detect recursive compressed responses.  A remote attacker could send a
  specially crafted packet, causing applications using Net::DNS to crash or
  monopolize CPU resources, leading to a denial of service.  (CVE-2007-3409)

  Affected Software/OS:
  libnet-dns-perl vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-July/000556.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libnet-dns-perl vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"libnet-dns-perl", ver:"0.53-2ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"libnet-dns-perl", ver:"0.57-1ubuntu1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}