###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for pulseaudio vulnerability USN-465-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840160);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "465-1");
  script_cve_id("CVE-2007-1804");
  script_name( "Ubuntu Update for pulseaudio vulnerability USN-465-1");
  desc = "

  Vulnerability Insight:

  Luigi Auriemma discovered multiple flaws in pulseaudio's network
  processing code.  If an unauthenticated attacker sent specially crafted
  requests to the pulseaudio daemon, it would crash, resulting in a denial
  of service.

  Affected Software/OS:
  pulseaudio vulnerability on Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-May/000537.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of pulseaudio vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"libpulse-browse0", ver:"0.9.5-5ubuntu4.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpulse-dev", ver:"0.9.5-5ubuntu4.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpulse-mainloop-glib0", ver:"0.9.5-5ubuntu4.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libpulse0", ver:"0.9.5-5ubuntu4.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-esound-compat", ver:"0.9.5-5ubuntu4.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-gconf", ver:"0.9.5-5ubuntu4.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-hal", ver:"0.9.5-5ubuntu4.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-lirc", ver:"0.9.5-5ubuntu4.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-x11", ver:"0.9.5-5ubuntu4.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-module-zeroconf", ver:"0.9.5-5ubuntu4.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio-utils", ver:"0.9.5-5ubuntu4.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"pulseaudio", ver:"0.9.5-5ubuntu4.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}