###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for firefox regression USN-428-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840114);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "428-2");
  script_cve_id("CVE-2006-6077", "CVE-2007-0780", "CVE-2007-0800", "CVE-2007-0981", "CVE-2007-0995", "CVE-2007-0996", "CVE-2007-0008", "CVE-2007-0009", "CVE-2007-0775", "CVE-2007-0776", "CVE-2007-0777", "CVE-2007-1092", "CVE-2007-0778", "CVE-2007-0779");
  script_name( "Ubuntu Update for firefox regression USN-428-2");
  desc = "

  Vulnerability Insight:

  USN-428-1 fixed vulnerabilities in Firefox 1.5.  However, changes to
  library paths caused applications depending on libnss3 to fail to start
  up.  This update fixes the problem.
  
  We apologize for the inconvenience.
  
  Original advisory details:
  
  Several flaws have been found that could be used to perform Cross-site
  scripting attacks. A malicious web site could exploit these to modify
  the contents or steal confidential data (such as passwords) from other
  opened web pages. (CVE-2006-6077, CVE-2007-0780, CVE-2007-0800,
  CVE-2007-0981, CVE-2007-0995, CVE-2007-0996)
  
  The SSLv2 protocol support in the NSS library did not sufficiently
  check the validity of public keys presented with a SSL certificate. A
  malicious SSL web site using SSLv2 could potentially exploit this to
  execute arbitrary code with the user's privileges.  (CVE-2007-0008)
  
  The SSLv2 protocol support in the NSS library did not sufficiently
  verify the validity of client master keys presented in an SSL client
  certificate. A remote attacker could exploit this to execute arbitrary
  code in a server application that uses the NSS library.
  (CVE-2007-0009)
  
  Various flaws have been reported that could allow an attacker to
  execute arbitrary code with user privileges by tricking the user into
  opening a malicious web page. (CVE-2007-0775, CVE-2007-0776,
  CVE-2007-0777, CVE-2007-1092)
  
  Two web pages could collide in the disk cache with the result that
  depending on order loaded the end of the longer document could be
  appended to the shorter when the shorter one was reloaded from the
  cache. It is possible a determined hacker could construct a targeted
  attack to steal some sensitive data from a particular web page. The
  potential victim would have to be already logged into the targeted
  service (or be fooled into doing so) and then visit the malicious
  site. (CVE-2007-0778)
  
  David Eckel reported that browser UI elements--such as the host name
  and security indicators--could be spoofed by using custom cursor
  images and a specially crafted style sheet. (CVE-2007-0779)

  Affected Software/OS:
  firefox regression on Ubuntu 6.06 LTS

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-March/000493.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of firefox regression");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"firefox-dbg", ver:"1.5.dfsg+1.5.0.10-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"1.5.dfsg+1.5.0.10-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"1.5.dfsg+1.5.0.10-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"1.5.dfsg+1.5.0.10-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"1.5.dfsg+1.5.0.10-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr-dev", ver:"1.firefox1.5.dfsg+1.5.0.10-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr4", ver:"1.firefox1.5.dfsg+1.5.0.10-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss-dev", ver:"1.firefox1.5.dfsg+1.5.0.10-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss3", ver:"1.firefox1.5.dfsg+1.5.0.10-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dev", ver:"1.5.dfsg+1.5.0.10-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox", ver:"1.5.dfsg+1.5.0.10-0ubuntu0.6.06.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}