###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for tetex-bin vulnerability USN-410-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840035);
  script_version("$Revision: 1.0 $");
  script_xref(name: "USN", value: "410-2");
  script_cve_id("CVE-2007-0104");
  script_name( "Ubuntu Update for tetex-bin vulnerability USN-410-2");
  desc = "

  Vulnerability Insight:

  USN-410-1 fixed vulnerabilities in the poppler PDF loader library.  This
  update provides the corresponding updates for a copy of this code in
  tetex-bin in Ubuntu 5.10.  Versions of tetex-bin after Ubuntu 5.10 use
  poppler directly and do not need a separate update.
  
  Original advisory details:
  
  The poppler PDF loader library did not limit the recursion depth of
  the page model tree. By tricking a user into opening a specially
  crafter PDF file, this could be exploited to trigger an infinite loop
  and eventually crash an application that uses this library.

  Affected Software/OS:
  tetex-bin vulnerability on Ubuntu 5.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-January/000474.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of tetex-bin vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"libkpathsea-dev", ver:"2.0.2-30ubuntu3.6", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libkpathsea3", ver:"2.0.2-30ubuntu3.6", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"tetex-bin", ver:"2.0.2-30ubuntu3.6", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}