###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_thunderbird_mult_vuln_dec08_win.nasl 725 2008-12-19 15:20:27Z dec $
#
# Mozilla Thunderbird Multiple Vulnerabilities December-08 (Win)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800090);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5500", "CVE-2008-5501", "CVE-2008-5502", "CVE-2008-5503",
                "CVE-2008-5506", "CVE-2008-5507", "CVE-2008-5508", "CVE-2008-5510",
                "CVE-2008-5511", "CVE-2008-5512");
  script_bugtraq_id(32882);
  script_name("Mozilla Thunderbird Multiple Vulnerabilities December-08 (Win)");
  desc = "

  Overview: The host is installed with Mozilla Thunderbird and is prone to
  multiple vulnerabilities.

  Vulnerability:
  Refer to the reference links for more information on the vulnerabilities.

  Impact:
  Successful exploitation could result in remote arbitrary code execution,
  bypass security restrictions, sensitive information disclosure, cross
  site scripting attacks and execute JavaScript code with chrome privileges.

  Impact Level: System

  Affected Software/OS:
  Thunderbird version prior to 2.0.0.19 on Windows.

  Fix: Upgrade to Thunderbird version 2.0.0.19
  http://www.mozilla.com/en-US/thunderbird/all.html

  References:
  http://www.mozilla.org/security/announce/2008/mfsa2008-60.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-61.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-64.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-65.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-66.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-67.html
  http://www.mozilla.org/security/announce/2008/mfsa2008-68.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Thunderbird");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_thunderbird_detect_win.nasl");
  exit(0);
}


include("version_func.inc");

tbVer = get_kb_item("Thunderbird/Win/Ver");
if(!tbVer){
  exit(0);
}

# Thunderbird version < 2.0.0.19
if(version_is_less(version:tbVer, test_version:"2.0.0.19")){
  security_hole(0);
}
