###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_tematres_mult_xss_n_sql_inj_vuln.nasl 2203 2009-05-11 15:15:17Z may $
#
# TemaTres Multiple XSS and SQL Injection Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800801);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1583", "CVE-2009-1584", "CVE-2009-1585");
  script_bugtraq_id(34830);
  script_name("TemaTres Multiple XSS and SQL Injection Vulnerabilities");
  desc = "

  Overview: The host is running TemaTres and is prone to Multiple XSS and SQL
  Injection Vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are due to
  - In-adequate check of user supplied input which causes input validation error
    in the search form.
  - Validation check error in accepting user input for the following parameters
     a) _expresion_de_busqueda, b) letra  c) estado_id and d) tema e) PATH_TO
     inside index.php.
  - Validation check error in accepting user input for the following parameters
     a) y b) ord and c) m inside sobre.php.
  - Validation check error in accepting user input for the following parameters
     a) mail b) password inside index.php.
  - Validation check error in accepting user input for the following parameters
     a) dcTema b) madsTema c) zthesTema d) skosTema and e) xtmTema inside xml.php.

  Impact:
  Successful attacks will let the attacker steal cookie-based authentication
  credentials, compromise the application, access or modify data, or can exploit
  latest vulnerabilities in the underlying database when 'magic_quotes_gpc' is
  disabled.

  Impact Level: Application

  Affected Software/OS:
  TemaTres version 1.031 and prior

  Fix: No solution or patch is available as on 18th May, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.r020.com.ar/tematres/index.en.html#indice

  References:
  http://secunia.com/advisories/34983
  http://secunia.com/advisories/34990
  http://www.milw0rm.com/exploits/8615
  http://www.milw0rm.com/exploits/8616

  CVSS Score:
    CVSS Base Score     : 6.8 (AV:N/AC:M/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.1
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of TemaTres");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_tematres_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

tematresPort = get_http_port(default:80);
if(!tematresPort){
  exit(0);
}

tematresVer = get_kb_item("www/" + tematresPort + "/TemaTres");
tematresVer = eregmatch(pattern:"^(.+) under (/.*)$", string:tematresVer);
if(tematresVer[1] != NULL)
{
  if(version_is_less_equal(version:tematresVer[1], test_version:"1.031")){
    security_hole(tematresPort);
  }
}
