###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sun_java_sys_web_serv_xss_vuln_win.nasl 2740 2009-06-17 17:58:32Z june $
#
# Sun Java System Web Server XSS Vulnerability (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800811);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1934");
  script_bugtraq_id(35204);
  script_name("Sun Java System Web Proxy Server Vulnerabilities (Win)");
  desc = "
  Overview: This host has Sun Java Web Server running on Windows, which is prone
  to Cross-Site Scripting vulnerability.

  Vulnerability Insight:
  The Flaw is due to, error in 'Reverse Proxy Plug-in' which is not properly
  sanitized the input data before being returned to the user. This can be
  exploited to inject arbitrary web script or HTML via the query string in
  situations that result in a 502 Gateway error.

  Impact:
  Successful exploitation will lets the attackers to execute arbitrary code,
  gain sensitive information by conducting XSS attacks in the context of a 
  affected site.

  Impact Level: System/Application

  Affected Software/OS:
  Sun Java System Web Server versions 6.1 and before 6.1 SP11 on Windows.

  Fix: Update to Web Server version 6.1 SP11
  http://www.sun.com/download/index.jsp
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-259588-1

  References:
  http://secunia.com/advisories/35338
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-116648-23-1

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Java System Web Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_sun_java_sys_web_serv_detect.nasl", "secpod_reg_enum.nasl");
  script_require_keys("Sun/Java/SysWebServ/Ver", "SMB/WindowsVersion");
  script_require_ports("Services/www", 80, 8888);
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(get_kb_item("Sun/JavaSysWebServ/Ver") >!< "6.1"){
  exit(0);
}

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Sun Microsystems\WebServer")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  jswsName = registry_get_sz(key:key + item, item:"DisplayName");
  if(jswsName != NULL && jswsName =~ "Sun (ONE |Java System )Web Server")
  {
    jswsVer = eregmatch(pattern:"Web Server ([0-9.]+)(SP[0-9]+)?",
                        string:jswsName);
    if(jswsVer[1] != NULL)
    {
      if(jswsVer[2] != NULL)
         jswsVer = jswsVer[1] + "." + jswsVer[2];
      else
        jswsVer = jswsVer[1];

      # Grep for versions 6.1 < 6.1SP11
      if(version_in_range(version:jswsVer, test_version:"6.1",
                                           test_version2:"6.1.SP10"))
      {
        jswsPort = get_kb_item("Sun/JavaSysWebServ/Port");
        security_warning(jswsPort);
        exit(0);
      }
    }
  }
}
