###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sun_java_sys_web_proxy_server_dos_vuln_lin.nasl 3682 2009-08-11 21:38:32Z aug $
#
# Sun Java System Web Proxy Server Denial Of Service Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800866);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-2597");
  script_bugtraq_id(35788);
  script_name("Sun Java System Web Proxy Server Denial Of Service Vulnerability (Linux)");
  desc = "

  Overview: This host has Java Web Proxy Server running, which is prone to
  Denial of Service vulnerability.

  Vulnerability Insight:
  The flaw is caused due to an unspecified error, which can be exploited to
  cause a crash via a 'GET' request, if the Sun Java System Web Proxy Server is
  the used deployment container for the agent.

  Impact:
  Successful exploitation will let the attackers to cause a Denial of Service
  in the context of an affected application.

  Impact Level: Application

  Affected Software/OS:
  Sun Java System Access Manager Policy Agent version 2.2
  Sun Java System Web Proxy Server version 4.0.x on Linux.

  Fix: Apply patch 141248-01 or later
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-141248-01-1

  *****
  NOTE: Ignore this warning if above mentioned patch is already applied.
  *****

  References:
  http://secunia.com/advisories/35979/
  http://sunsolve.sun.com/search/document.do?assetkey=1-66-258508-1

  CVSS Score:
    CVSS Base Score     : 7.8 (AV:N/AC:L/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 5.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Web Proxy Server and AM Policy Agent");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_sun_java_sys_web_proxy_server_detect.nasl");
  script_require_keys("Sun/JavaWebProxyServ/Ver", "Sun/JavaWebProxyServ/Port");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

if(get_kb_item("Sun/JavaWebProxyServ/Ver") >!< "4.0"){
  exit(0);
}

sun_sock = ssh_login_or_reuse_connection();
if(!sun_sock){
  exit(0);
}

paths = find_file(file_name:"config_linux", file_path:"/proxy4/bin/",
                  useregex:TRUE, regexpar:"$", sock:sun_sock);

foreach agentBin (paths)
{
  #Grep for Access Manager Policy Agent Version
  agentVer = get_bin_version(full_prog_name:"cat", version_argv:chomp(agentBin),
                            ver_pattern:"proxy4agent-([0-9.]+)", sock:sun_sock);

  
  if(!isnull(agentVer[1]))
  {
    # Check for Access Manager Policy Agent Version
    if(version_is_equal(version:agentVer[1], test_version:"2.2"))
    {
      sun_port = get_kb_item("Sun/JavaWebProxyServ/Port");
      security_hole(sun_port);
      exit(0);
    }
  }
}
