###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_stardict_detect_lin.nasl 3194 2009-07-07 15:21:24Z jul $
#
# StarDict Version Detection (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800643);
  script_version("Revision: 1.0 ");
  script_name("StarDict Version Detection (Linux)");
  desc = "

  Overview: This script detects the installed version of StarDict and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of StarDict");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

stardict_sock = ssh_login_or_reuse_connection();
if(!stardict_sock){
  exit(0);
}

paths = find_bin(prog_name:"stardict", sock:stardict_sock);
foreach stardictbin (paths)
{
  stardictVer = get_bin_version(full_prog_name:chomp(stardictbin),
                                sock:stardict_sock, version_argv:"--version",
                                ver_pattern:"stardict ([0-9._]+)");
  if(stardictVer[1] != NULL)
  {
    set_kb_item(name:"StarDict/Linux/Ver", value:stardictVer[1]);
    ssh_close_connection();
  }
}
ssh_close_connection();
