###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_south_river_webdrive_loc_prev_esc_vuln.nasl 6803 2010-01-25 16:04:27Z jan $
#
# South River Technologies WebDrive Local Privilege Escalation Vulnerability
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800159);
  script_version("$Revision: 6582 $: 1.0");
  script_cve_id("CVE-2009-4606");
  script_name("South River Technologies WebDrive Local Privilege Escalation Vulnerability");
  desc = "
  Overview: This host is installed with South River Technologies WebDrive and
  is prone to Local Privilege Escalation Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to the WebDrive Service being installed without
  security descriptors, which could be exploited by local attackers to,
  - stop the service via the stop command
  - restart the service via the start command
  - execute arbitrary commands with elevated privileges by changing the
    service 'binPath' configuration.

  Impact:
  Successful exploitation will let the local attacker to execute arbitrary
  commands with an elevated privileges.

  Impact Level: System/Application

  Affected Software/OS:
  South River WebDrive version 9.02 build 2232 and prior on Windows.

  Fix: No solution or patch is available as on 25th January, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.webdrive.com/download/index.html

  References:
  http://secunia.com/advisories/37083/
  http://retrogod.altervista.org/9sg_south_river_priv.html
  http://www.securityfocus.com/archive/1/archive/1/507323/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 7.2 (AV:L/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of South River WebDrive");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Intevation GmbH");
  script_family("Privilege escalation");
  script_dependencies("gb_south_river_webdrive_detect.nasl");
  script_require_keys("SouthRiverWebDrive/Win/Ver");
  exit(0);
}


include("version_func.inc");

## Get South River WebDrive Version from KB
webDriveVer = get_kb_item("SouthRiverWebDrive/Win/Ver");
if(webDriveVer != NULL)
{
  # Check for South River WebDrive Version < 9.02 build 2232 (9.02.2232)
  if(version_is_less_equal(version:webDriveVer, test_version:"9.02.2232")){
    security_hole(0);
  }
}
