###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_south_river_webdrive_detect.nasl 6803 2010-01-25 15:19:28Z jan $
#
# South River WebDrive Version Detection
#
# Authors:
# Veerendra G <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800158);
  script_version("$Revision: 6582 $: 1.0");
  script_name("South River WebDrive Version Detection");
  desc = "
  Overview: This script detects the installed South River WebDrive and
  saves the version in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set version of South River WebDrive in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

## Windows Confirmation
if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

## South River Web Drive Application confirmation
if(!registry_key_exists(key:"SOFTWARE\South River Technologies\WebDrive")){
  exit(0);
}

## Get the South River Web Drive Version
key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  webDrive = registry_get_sz(key:key + item, item:"DisplayName");
  if("WebDrive" >< webDrive)
  {
    webDriveVer = registry_get_sz(key:key + item, item:"DisplayVersion");
    if( webDriveVer != NULL){
       set_kb_item(name:"SouthRiverWebDrive/Win/Ver", value:webDriveVer);
    }
    exit(0);
  }
}
