###############################################################################
# OpenVAS Vulnerability Test
#
# Solaris Update for kernel 127127-11
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(855322);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUNSolve", value: "127127-11");
  script_cve_id("CVE-2006-3738", "CVE-2006-4343", "CVE-2006-4339", "CVE-2006-2937", "CVE-2006-2940", "CVE-2007-5135");
  script_name( "Solaris Update for kernel 127127-11");
  desc = "

  Vulnerability Insight:
  The remote host is missing a patch containing a security fix,
  which affects the following component(s): 
  kernel
  For more information please visit the below reference link.

  Affected Software/OS:
  kernel on solaris_5.10_sparc

  Fix: Please Install the Updated Packages.

  References:
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-127127-11-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kernel");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Solaris Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/solosversion");
  exit(0);
}


include("solaris.inc");

release = get_kb_item("ssh/login/solosversion");

if(release == NULL){
  exit(0);
}

if(solaris_check_patch(release:"5.10", arch:"sparc", patch:"127127-11", package:"SUNWgssdh SUNWcakr.u SUNWrcmdc SUNWpsu SUNWfss SUNWatfsu SUNWscplp SUNWudapltu SUNWrds SUNWarc SUNWcakrnt2000.v SUNWfmd SUNWintgige SUNWbtool SUNWidn.u FJSVcpcu SUNWperl584core SUNWypr SUNWcry SUNWkrbu SUNWdrcr.u SUNWsmapi SUNWtavor SUNWgssk SUNWmdb SUNWzfsu SUNWaudit SUNWtsr SUNWldomr.v SUNWiopc.v SUNWcakr.us SUNWpapi SUNWcart200.v SUNWcpr.u SUNWkvm.u SUNWsndmu SUNWnfssu SUNWkdcu SUNWmdr SUNWpcr SUNWkvm.v SUNWkvm.us FJSVhea SUNWxcu4 SUNWudapltr SUNWdtrc SUNWopenssl-libraries FJSVfmd SUNWus.u SUNWcsl FJSVmdbr SUNWcpcu SUNWrcmds SUNWvolu SUNWniumx.v SUNWcpc.v SUNWib SUNWnisu SUNWtoo SUNWcryr SUNWdrr.u FJSVpiclu SUNWkvmt200.v SUNWefc.u SUNWtnetc SUNWpiclu SUNWtsg SUNWypu SUNWftduu SUNWppm SUNWcakr.v SUNWusb SUNWn2cp.v SUNWcti2.u SUNWzfsr SUNWdrr.us SUNWckr SUNWcsr SUNWfruid SUNW1394 SUNWgss SUNWkrbr SUNWtsu SUNWmdbr SUNWpd SUNWldomu.v SUNWpcu SUNWzfskr SUNWarcr SUNWmdu FJSVmdb SUNWpamsc SUNWwbsup SUNWcar.v SUNWhea SUNWnfsckr SUNWdtrp SUNWspnego SUNWdcar SUNWcpc.us SUNWpl5u SUNWnfsskr SUNWtnetd SUNWcslr SUNWippcore SUNWcsu SUNWust1.v SUNWnxge.v SUNWnfscu SUNWesu SUNWnxge.u SUNWcsd SUNWfruip.u SUNWpsr SUNWssad SUNWpdu SUNWcpc.u SUNWipplr SUNWpsm-lpd SUNWluxl SUNWefc.us SUNWzoneu SUNWipplu SUNWust2.v SUNWnfscr SUNWwrsm.u SUNWftdur SUNWpiclr SUNWcstl") < 0)
{
  security_hole(0);
  exit(0);
}