###############################################################################
# OpenVAS Vulnerability Test
#
# Solaris Update for Apache 1.3 122912-19
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(855821);
  script_version("$Revision: 6624 $: 1.0");
  script_xref(name: "SUNSolve", value: "122912-19");
  script_cve_id("CVE-2009-0796", "CVE-2008-5519", "CVE-2007-5000", "CVE-2007-6388", "CVE-2006-5752", "CVE-2007-3304", "CVE-2005-3352", "CVE-2006-3747", "CAN-2005-2700", "CAN-2005-2088");
  script_name("Solaris Update for Apache 1.3 122912-19");
  desc = "

  Vulnerability Insight:
  The remote host is missing a patch containing a security fix,
  which affects the following component(s): 
  Apache 1.3
  For more information please visit the below reference link.

  Affected Software/OS:
  Apache 1.3 on solaris_5.10_x86

  Fix: Please Install the Updated Packages.

  References:
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-122912-19-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Apache 1.3");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Solaris Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/solosversion");
  exit(0);
}


include("solaris.inc");

release = get_kb_item("ssh/login/solosversion");

if(release == NULL){
  exit(0);
}

if(solaris_check_patch(release:"5.10", arch:"i386", patch:"122912-19", package:"SUNWapchS SUNWtcatu SUNWapchr SUNWtcatr SUNWapchd SUNWapchu") < 0)
{
  security_hole(0);
  exit(0);
}