###############################################################################
# OpenVAS Vulnerability Test
#
# Solaris Update for Sun XVR-2500 Graphics Accelerator 120928-31
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(855871);
  script_version("$Revision: 6743 $: 1.0");
  script_xref(name: "SUNSolve", value: "120928-31");
  script_name("Solaris Update for Sun XVR-2500 Graphics Accelerator 120928-31");
  desc = "

  Vulnerability Insight:
  The remote host is missing a patch containing a security fix,
  which affects the following component(s): 
  Sun XVR-2500 Graphics Accelerator
  For more information please visit the below reference link.

  Affected Software/OS:
  Sun XVR-2500 Graphics Accelerator on solaris_5.10_sparc

  Fix: Please Install the Updated Packages.

  References:
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-120928-31-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Sun XVR-2500 Graphics Accelerator");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Solaris Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/solosversion");
  exit(0);
}


include("solaris.inc");

release = get_kb_item("ssh/login/solosversion");

if(release == NULL){
  exit(0);
}

if(solaris_check_patch(release:"5.10", arch:"sparc", patch:"120928-31", package:"SUNWkfb.v SUNWkfb.u SUNWkfbw SUNWkfbcf SUNWkfbr") < 0)
{
  security_hole(0);
  exit(0);
}