###############################################################################
# OpenVAS Vulnerability Test
#
# Solaris Update for Ghostscript 115836-05
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(855758);
  script_version("$Revision: 1.0 $");
  script_xref(name: "SUNSolve", value: "115836-05");
  script_cve_id("CVE-2009-0583", "CVE-2009-0584", "CVE-2009-0792", "CVE-2008-6679", "CVE-2009-0196", "CVE-2007-6725");
  script_name("Solaris Update for Ghostscript 115836-05");
  desc = "

  Vulnerability Insight:
  The remote host is missing a patch containing a security fix,
  which affects the following component(s): 
  Ghostscript
  For more information please visit the below reference link.

  Affected Software/OS:
  Ghostscript on solaris_5.9_x86

  Fix: Please Install the Updated Packages.

  References:
  http://sunsolve.sun.com/search/document.do?assetkey=1-21-115836-05-1

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Ghostscript");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Solaris Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/solosversion");
  exit(0);
}


include("solaris.inc");

release = get_kb_item("ssh/login/solosversion");

if(release == NULL){
  exit(0);
}

if(solaris_check_patch(release:"5.9", arch:"i386", patch:"115836-05", package:"SUNWespgs SUNWffiltersu SUNWa2psu SUNWgscr SUNWhpijs SUNWespgsS SUNWa2psr SUNWgscrS") < 0)
{
  security_hole(0);
  exit(0);
}