###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_snort_ipv6_dos_vuln_lin.nasl 5534 2009-11-02 20:08:24Z nov $
#
# Snort 'IPv6' Packet Denial Of Service Vulnerability (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801139);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3641");
  script_bugtraq_id(36795);
  script_name("Snort 'IPv6' Packet Denial Of Service Vulnerability (Linux)");
  desc = "
  Overview: This host has Snort installed and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  This flaw is caused by an error when processing malformed IPv6 packets when
  the application is compiled with the '--enable-ipv6' option and is running
  in verbose mode (-v).

  Impact:
  Successful exploitation could allow attacker to crash an affected application,
  creating a denial of service condition.

  Impact Level: Application

  Affected Software/OS:
  Snort version prior to 2.8.5.1 on Linux.

  Fix: Upgrade to Snort version 2.8.5.1 or later
  For updates, Refer http://www.snort.org/downloads

  References:
  http://secunia.com/advisories/37135
  http://xforce.iss.net/xforce/xfdb/53912
  http://www.vupen.com/english/advisories/2009/3014
  https://bugzilla.redhat.com/show_bug.cgi?id=530863

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Snort");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_snort_detect_lin.nasl");
  script_require_keys("Snort/Linux/Ver");
  exit(0);
}


include("version_func.inc");

snortVer  = get_kb_item("Snort/Linux/Ver");
if(!snortVer ){
  exit(0);
}

# Check for Snort version < 2.8.5.1
if(version_is_less(version:snortVer , test_version:"2.8.5.1")){
  security_warning(0);
}
