###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_snort_detect_lin.nasl 5534 2009-11-02 20:00:29Z nov $
#
# Snort Version Detection (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801138);
  script_version("$Revision: 1.0 $");
  script_name("Snort Version Detection (Linux)");
  desc = "
  Overview: This script detects the installed version of Snort and
  sets the reuslt in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set KB for the version of Snort");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

snortSock = ssh_login_or_reuse_connection();
if(!snortSock){
  exit(0);
}

paths = find_bin(prog_name:"snort",sock:snortSock);
foreach binName (paths)
{
  snortVer = get_bin_version(full_prog_name:chomp(binName), version_argv:"-V",
                             ver_pattern:"> Snort! <", sock:snortSock);
  snortVer = eregmatch(pattern:"Version ([0-9.]+)( \(Build.?([0-9]+)\))?",
                       string:snortVer[1], icase:1);
  if(snortVer[1])
  {
    set_kb_item(name:"Snort/Linux/Ver", value:snortVer[1]);
    if(snortVer[3])
    {
      snortVer = snortVer[1] + "." + snortVer[3];
      set_kb_item(name:"Snort/Linux/Build", value:snortVer);
    }
  }
}
ssh_close_connection();
