###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sinecms_detect.nasl 4516 2009-09-10 15:00:14Z sep $
#
# SineCMS Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800941);
  script_version("Revision: 1.0");
  script_name("SineCMS Version Detection");
  desc = "
  Overview: This script detects the installed version of SineCMS and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets the KB for the version of SineCMS");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation Gmb");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

sinePort = get_http_port(default:80);
if(!sinePort){
  sinePort = 80;
}

if(!get_port_state(sinePort))
{
  exit(0);
}

foreach dir (make_list("/", "/sinecms", "/sine", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:sinePort);
  rcvRes = http_send_recv(port:sinePort, data:sndReq);
  if("SineCMS" >< rcvRes)
  {
    sineVer = eregmatch(pattern:"SineCms Version: ([0-9.]+)", string:rcvRes);
    if(sineVer[1]!= NULL){
      set_kb_item(name:"www/" + sinePort + "/SineCMS", value:sineVer[1] +
                                                        " under " + dir);
    }
  }
}
