###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_shareaza_detect.nasl 4511 2009-09-10 12:25:24Z sep $
#
# Shareaza Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800603);
  script_version("$Revision: 1.0 $");
  script_name("Shareaza Version Detection");
  desc = "
  Overview: This script detects the installed version of Shareaza and
  sets the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Set version of Shareaza in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 6346);
  exit(0);
}


include("http_func.inc");

shareazaPort = get_http_port(default:6346);

if(!shareazaPort){
  shareazaPort = 6346;
}

if(!get_port_state(shareazaPort)){
  exit(0);
}

banner = get_http_banner(port:shareazaPort);

if("Shareaza" >< banner)
{
  shareazaVer = eregmatch(pattern:"Server: Shareaza ([0-9.]+)", string:banner);

  if(shareazaVer[1] != NULL){
    set_kb_item(name:"www/" + shareazaPort + "/Shareaza", value:shareazaVer[1]);
  }
}
