###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sendmail_detect.nasl 2153 2009-05-08 20:07:05Z may $
#
# Sendmail Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

if(description)
{
  script_id(800608);
  script_version("$Revision: 1.0 $");
  script_name("Sendmail Version Detection");
  desc = "

  Overview: The script will detects the installed version of Sendmail and sets
  the result in KB.

  Risk factor: Informational";

  script_description(desc);
  script_summary("Sets KB for the version of Sendmail");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencie("find_service.nes");
  script_require_ports("Services/smtp", 25);
  exit(0);
}


include("smtp_func.inc");

sendmailPort = get_kb_item("Services/smtp");

if(!sendmailPort){
  sendmailPort = 25;
}

if(!get_port_state(sendmailPort)){
  exit(0);
}

sendMail = get_smtp_banner(port:sendmailPort);

if(sendMail != NULL && "Sendmail" >< sendMail)
{
  sendmailVer = eregmatch(pattern:"ESMTP Sendmail ([0-9.]+)", string:sendMail);
  if(sendmailVer[1] != NULL){
    set_kb_item(name:"SMTP/" + sendmailPort + "/Sendmail", value:sendmailVer[1]);
  }
}
