###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sendmail_bof_vuln.nasl 2159 2009-05-11 17:05:29Z may $
#
# Sendmail Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800609);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1490");
  script_name("Sendmail Buffer Overflow Vulnerability");
  desc = "

  Overview:
  The host is running Sendmail and is prone to Buffer Overflow Vulnerability.

  Vulnerability Insight:
  Buffer overflow error is due to improper handling of long X- header.

  Impact:
  Successful exploitation will let the remote attacker to create the mangled
  message by execute arbitrary code, and can cause application crash.

  Affected Software/OS:
  Sendmail Version prior 8.13.2

  Fix: Upgrade to version 8.13.2 or later
  http://www.sendmail.org/releases

  References:
  http://www.sendmail.org/releases/8.13.2
  http://www.nmrc.org/~thegnome/blog/apr09

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Sendmail");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencie("gb_sendmail_detect.nasl");
  script_require_ports("Services/smtp", 25);
}


include("version_func.inc");

sendmailPort = get_kb_item("Services/smtp");

if(!sendmailPort){
  exit(0);
}

sendmailVer = get_kb_item("SMTP/" + sendmailPort + "/Sendmail");

if(sendmailVer != NULL)
{
  if(version_is_less(version:sendmailVer, test_version:"8.13.2")){
    security_warning(sendmailPort);
  }
}
