###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_sap_maxdb_detect.nasl 6988 2010-03-17 20:52:47Z mime $
#
# SAP MaxDB Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running SAP MaxDB. MaxDB is an ANSI SQL-92 (entry level) compliant
relational database management system (RDBMS) from SAP AG,

See also:
http://www.sdn.sap.com/irj/sdn/maxdb

Risk factor : None";

if (description)
{
 script_id(100540);
 script_version ("1.0-$Revision: 6988 $");
 script_name("SAP MaxDB Detection");
 script_description(desc);
 script_summary("Checks for the presence of SAP MaxDB");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("find_service.nes");
 script_require_ports("Services/unknown", 7210);
 exit(0);
}

include("misc_func.inc");
include("global_settings.inc");

port = get_kb_item("Services/unknown");
if(!port)port=7210;

if(get_port_state(port)) {

  soc = open_sock_tcp(port);
  if(soc) {

    req = raw_string(
                    0x5A,0x00,0x00,0x00,0x03,0x5B,0x00,0x00,0x01,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,
                    0x00,0x00,0x04,0x00,0x5A,0x00,0x00,0x00,0x00,0x02,0x42,0x00,0x04,0x09,0x00,0x00,
                    0x00,0x40,0x00,0x00,0xD0,0x3F,0x00,0x00,0x00,0x40,0x00,0x00,0x70,0x00,0x00,0x00,
                    0x00,0x07,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x03,0x00,0x00,
                    0x07,0x49,0x33,0x34,0x33,0x32,0x00,0x04,0x50,0x1C,0x2A,0x03,0x52,0x01,0x03,0x72,
                    0x01,0x09,0x70,0x64,0x62,0x6D,0x73,0x72,0x76,0x00);

    send(socket:soc, data:req);
    buf = recv(socket:soc, length:2048);

    if("pdbmsrv" >!< buf) {
      close(soc);
      exit(0);
    }

    db_version = raw_string(0x28,0x00,0x00,0x00,0x03,0x3f,0x00,0x00,0x01,0x00,0x00,0x00,0xc0,0x0b,0x00,0x00,
                            0x00,0x00,0x04,0x00,0x28,0x00,0x00,0x00,0x64,0x62,0x6d,0x5f,0x76,0x65,0x72,0x73,
                            0x69,0x6f,0x6e,0x20,0x20,0x20,0x20,0x20);

    send(socket:soc, data:db_version);
    buf = recv(socket:soc, length:2048);
    close(soc);
  
    if("VERSION" >!< buf)exit(0);

    lines = split(buf, sep:'\n', keep:FALSE);

    foreach line (lines) {

      data = eregmatch(pattern:"^([^ =]+) *= *(.*)$", string:line);
    
      if(!isnull(data[1]) && !isnull(data[2])) {
     
        if(data[1] == "VERSION") {
          version = data[2];
          set_kb_item(name: string("sap_maxdb/",port,"/version"), value: version);
        }

        else if(data[1] == "BUILD") {
        
          build = eregmatch(pattern:"Build ([0-9-]+)", string: data[2]);
        
          if(!isnull(build[1])) {
            set_kb_item(name: string("sap_maxdb/",port,"/build"), value: build[1]);  
          }
        }

        info += string(data[1], " : ", data[2], "\n");

      }

    }

     if(version) {
       set_kb_item(name: string("cpe:/a:sap:maxdb:",version), value: TRUE);
     } else {
       set_kb_item(name: string("cpe:/a:sap:maxdb"), value: TRUE);
     }

     if(info) {
       info = string("None\n\nInformation that was gathered:\n\n", info);
       desc = ereg_replace(
          string:desc,
          pattern:"None$",
          replace:info
       );
     }
 
      if(report_verbosity > 0) {
        security_note(port:port, data:desc);
      }

  }
}

exit(0);
