###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_samba_dos_vuln.nasl 2204 2009-05-08 16:20:29Z may $
#
# Samba winbind Daemon Denial of Service Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800711);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-6800");
  script_name("Samba winbind Daemon Denial of Service Vulnerability");
  desc = "

  Overview: This host is installed with Samba for Linux and is prone to
  Winbind daemon Denial of Service Vulnerability.

  Vulnerability Insight:
  This flaw is due to a race condition in the winbind daemon which allows
  remote attackers to cause denial of service through unspecified vectors
  related to an unresponsive child process.

  Impact:
  Successful exploitation will let the attacker crash the application.

  Impact level: Application

  Affected Software/OS:
  Samba version prior to 3.0.32

  Fix:
  Upgrade to the latest version 3.0.32
  http://us1.samba.org/samba

  References:
  http://wiki.rpath.com/wiki/Advisories:rPSA-2008-0308
  http://www.samba.org/samba/history/samba-3.0.32.html
  http://www.securityfocus.com/archive/1/archive/1/497941/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.2
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Samba");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_samba_detect.nasl");
  script_require_keys("Samba/Version");
  exit(0);
}


include("version_func.inc");

sambaVer = get_kb_item("Samba/Version");
sambaVer = ereg_replace(pattern:"-", string:sambaVer, replace:".");
sambaVer = ereg_replace(pattern:"\.([a-z|A-Z].*)", string:sambaVer, replace:"");
if(sambaVer == NULL){
  exit(0);
}

# Grep for Samba version prior to 3.0.32
if(version_is_less(version:sambaVer, test_version:"3.0.32")){
  security_warning(0);
}
