###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_rhinosoft_serv-u_site_set_dos_vuln.nasl 5238 2009-10-20 22:48:26Z oct $
#
# Rhino Software Serv-U 'SITE SET' Command Denial Of Service vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801118);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3655");
  script_name("Rhino Software Serv-U 'SITE SET' Command Denial Of Service vulnerability");
  desc = "
  Overview: This host is installed with Rhino Software Serv-U and is prone to
  Denial of Service vulnerability.

  Vulnerability Insight:
  An error occurs when application handles the 'SITE SET TRANSFERPROGRESS ON'
  command.

  Impact:
  Successful exploitation will let the local attackers to cause a Denial of
  Service in the affected application.

  Impact Level: Application

  Affected Software/OS:
  Rhino Software Serv-U version prior to 9.0.0.1

  Fix: Upgrade to Rhino Software Serv-U version 9.0.0.1 or later.
  For Updates Refer, http://www.serv-u.com/dn.asp

  References:
  http://www.serv-u.com/releasenotes/
  http://secunia.com/advisories/36873/

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check  the version of Rhino Software Serv-U");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_rhinosoft_serv-u_detect.nasl", "find_service.nes",
                      "ssh_detect.nasl");
  script_require_keys("Serv-U/FTP/Ver");
  script_require_ports("Services/ftp", 21, "Services/ssh", 22);
  exit(0);
}


include("ftp_func.inc");
include("version_func.inc");

servuPort = get_kb_item("Services/ssh");
if(!servuPort)
{
  servuPort = get_kb_item("Services/ftp");
  if(!servuPort)
    exit(0);
}

servuVer = get_kb_item("Serv-U/FTP/Ver");
# Check for Rhino Software Serv-U versions < 9.0.0.1
if(servuVer =~ "^(7|8)\..*"){
  security_hole(servuPort);
}
