###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_reflection_secureit_unix_detect_lin.nasl 936 2009-02-06 13:40:29Z feb $
#
# Reflection for Secure IT Version Detection (Linux)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800227);
  script_version("$Revision: 1.0 $");
  script_name("Reflection for Secure IT Version Detection (Linux)");
  desc = "

  Overview: The script detects the version of Reflections for Secure IT and
  sets the version in KB.

  Risk Factor: Informational";

  script_description(desc);
  script_summary("Set the KB of Reflections for Secure IT (Linux)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("find_service.nes", "ssh_detect.nasl");
  script_require_ports("Services/ssh", 22);
  exit(0);
}


include("ssh_func.inc");

sshPort = get_kb_item("Services/ssh");
if(!sshPort){
  sshPort = 22;
}

secureItVer = eregmatch(pattern:"SSH\-.*ReflectionForSecureIT_([0-9.]+)",
                        string:get_kb_item("SSH/banner/" + sshPort));
if(secureItVer[1] != NULL){
  set_kb_item(name:"Reflection/SecureIT/Linux/Ver", value:secureItVer[1]);
}
