###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_pidgin_oscar_dos_vuln_oct09_lin.nasl 5395 2009-10-22 20:13:17Z oct $
#
# Pidgin Oscar Protocol Denial of Service Vulnerability (Linux)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801031);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-3615");
  script_bugtraq_id(36719);
  script_name("Pidgin Oscar Protocol Denial of Service Vulnerability (Linux)");
  desc = "
  Overview: This host has Pidgin installed and is prone to Denial of Service
  vulnerability.

  Vulnerability Insight:
  This issue is caused by an error in the Oscar protocol plugin when processing
  malformed ICQ or AIM contacts sent by the SIM IM client, which could cause an
  invalid memory access leading to a crash.

  Impact:
  Successful exploitation will let the attacker to cause a Denial of Service.

  Impact Level: Application

  Affected Software/OS:
  Pidgin version prior to 2.6.3 on Linux.

  Fix: Upgrade to Pidgin version 2.6.3
  http://pidgin.im/download

  References:
  http://secunia.com/advisories/37072
  http://xforce.iss.net/xforce/xfdb/53807
  http://www.pidgin.im/news/security/?id=41
  http://developer.pidgin.im/wiki/ChangeLog

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Pidgin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_pidgin_detect_lin.nasl");
  script_require_keys("Pidgin/Lin/Ver");
  exit(0);
}


include("version_func.inc");

pidginVer = get_kb_item("Pidgin/Lin/Ver");
if(pidginVer != NULL)
{
  if(version_is_less(version:pidginVer, test_version:"2.6.3")){
    security_warning(0);
  }
}
