###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpmyadmin_mult_vuln_apr09.nasl 1270 2009-04-02 16:50:29Z apr $
#
# phpMyAdmin Multiple Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800381);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1148", "CVE-2009-1149", "CVE-2009-1150", "CVE-2009-1151");
  script_bugtraq_id(34251, 34253, 34236);
  script_name("phpMyAdmin Multiple Vulnerabilities");
  desc = "

  Overview: This host is running phpMyAdmin and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are due to,
  - BLOB streaming feature in 'bs_disp_as_mime_type.php' causes CRLF Injection
    which lets the attacker inject arbitrary data in the HTTP headers through
    the 'c_type' and 'file_type' parameters.
  - XSS Vulnerability in 'display_export.lib.php' as its not sanitizing the
    'pma_db_filename_template' parameter.
  - Static code injection vulnerability in 'setup.php' which can be used to
    inject PHP Codes.
  - Filename 'bs_disp_as_mime_type.php' which is not sanitizing user supplied
    inputs in the filename variable which causes directory traversal attacks.

  Impact:
  Successful exploitation will let the attacker cause XSS, Directory Traversal
  attacks or can injection malicious PHP Codes to gain sensitive information
  about the remote host.

  Affected Software/OS:
  phpMyAdmin version 2.11.x to 2.11.9.4 and 3.0.x to 3.1.3

  Fix:
  Upgrade to version 2.11.9.5 or 3.1.3.1
  http://www.phpmyadmin.net/home_page/downloads.php

  Workaround:
  Update the existing PHP files from the below SVN Revisions.
  http://phpmyadmin.svn.sourceforge.net/viewvc/phpmyadmin?view=rev&revision=12301
  http://phpmyadmin.svn.sourceforge.net/viewvc/phpmyadmin?view=rev&revision=12302
  http://phpmyadmin.svn.sourceforge.net/viewvc/phpmyadmin?view=rev&revision=12303

  *****
  Note: Igone the warning, if already replaced according to the fixed svn
        revision numbers.
  *****

  References:
  http://secunia.com/advisories/34430
  http://www.phpmyadmin.net/home_page/security/PMASA-2009-1.php
  http://www.phpmyadmin.net/home_page/security/PMASA-2009-2.php
  http://www.phpmyadmin.net/home_page/security/PMASA-2009-3.php

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of phpMyAdmin");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("secpod_phpmyadmin_detect_900129.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("version_func.inc");

pmaPort = get_kb_item("Services/www");
if(!pmaPort){
  pmaPort = 80;
}

pmaVer = get_kb_item("www/" + pmaPort + "/phpMyAdmin");
if(!pmaVer){
  exit(0);
}

pmaVer = eregmatch(pattern:"^(.+) under (/.*)$", string:pmaVer);
if(pmaVer[1])
{
  if(version_in_range(version:pmaVer[1], test_version:"2.11", test_version2:"2.11.9.4")||
     version_in_range(version:pmaVer[1], test_version:"3.0", test_version2:"3.1.3")){
    security_hole(pmaPort);
  }
}
