##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpgenealogie_rfi_vuln.nasl 5168 2009-10-07 09:56:24Z oct $
#
# PHPGenealogie 'CoupleDB.php' Remote File Inclusion Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801008);
  script_version("$Revision: 1.0$");
  script_cve_id("CVE-2009-3541");
  script_name("PHPGenealogie 'CoupleDB.php' Remote File Inclusion Vulnerability");
  desc = "
  Overview: This host is running PHPGenealogie and is prone to Remote File
  Inclusion vulnerability.

  Vulnerability Insight:
  The flaw is due to error in 'DataDirectory' parameter in 'CoupleDB.php' which
  is not properly verified before being used to include files.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary code on
  the vulnerable Web server.

  Impact level: Application/System

  Affected Software/OS:
  PHPGenealogie version 2.0

  Fix: No solution or patch is available as on 07th October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://sourceforge.net/projects/phpgenealogie/files/

  References:
  http://www.milw0rm.com/exploits/9155
  http://xforce.iss.net/xforce/xfdb/51728

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version and attack of PHPGenealogie");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_phpgenealogie_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

phpgenPort = get_http_port(default:80);
if(!phpgenPort){
  exit(0);
}

phpgenVer = get_kb_item("www/" + phpgenPort + "/PHPGenealogie");
phpgenVer = eregmatch(pattern:"^(.+) under (/.*)$", string:phpgenVer);

if((phpgenVer[2] != NULL) && (!safe_checks()))
{
  sndReq = http_get(item:string(phpgenVer[2], "/CoupleDB.php?Parametre=0&" +
                         "DataDirectory=xyz/OpenVAS-RemoteFileInclusion.txt"),
                    port:phpgenPort);
  rcvRes = http_send_recv(port:phpgenPort, data:sndReq);
  if("xyz/OpenVAS-RemoteFileInclusion.txt" >< rcvRes)
  {
    security_hole(phpgenPort);
    exit(0);
  }
}
else
{
  if(phpgenVer[1] != NULL)
  {
    if(version_is_equal(version:phpgenVer[1], test_version:"2.0")){
      security_hole(phpgenPort);
    }
  }
}
