###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_phpbugtracker_sql_inj_vuln.nasl 2595 2009-06-05 15:11:27Z june $
#
# phpBugTracker 'index.php' SQL Injection Vulnerability
#
# Authors:
# Antu Sanadi<santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800621);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-1850");
  script_bugtraq_id(35101);
  script_name("phpBugTracker 'index.php' SQL Injection Vulnerability");
  desc = "

  Overview: The host is running phpBugTracker and is prone to SQL Injection
  Vulnerability.

  Vulnerability Insight:
  The flaw is caused due to error in 'index.php', it fails to sufficiently
  sanitize user-supplied data before using it in an SQL query.

  Impact:
  Successful exploitation will let the attacker to compromise the application,
  access or modify data, or exploit latent vulnerabilities in the underlying
  database.

  Impact Level: Application

  Affected Software/OS:
  phpBugTracker 1.0.3 and prior on all running platform.

  Fix: No solution/patch is available as on 05th June, 2009. Information
  regarding this issue will updated once the solution details are available.
  For updates refer,http://phpbt.sourceforge.net/

  References:
  http://www.milw0rm.com/exploits/8808
  http://xforce.iss.net/xforce/xfdb/50752

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 6.7
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of phpBugTracker");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_dependencies("phpBugTracker_detect.nasl");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

bugtrackport = get_http_port(default:80);
if(!bugtrackport){
  exit(0);
}

bugtrackVer = get_kb_item("www/"+ bugtrackport + "/phpBugTracker");
if(!bugtrackVer){
  exit(0);
}

bugtrackVer = eregmatch(pattern:"^(.+) under (/.*)$", string:bugtrackVer);
if(bugtrackVer[1] != NULL)
{
  if(version_is_less_equal(version:bugtrackVer[1], test_version:"1.0.3")){
    security_hole(bugtrackport);
  }
}
