###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_php_sql_inj_vuln.nasl 818 2009-01-06 15:14:56Z jan $
#
# FILTER_UNSAFE_RAW SQL Injection Vulnerability in PHP
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800333);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5844");
  script_bugtraq_id(32673);
  script_name("FILTER_UNSAFE_RAW SQL Injection Vulnerability in PHP");
  desc = "

  Overview: The host is running PHP and is prone to SQL Injection vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper field change in FILTER_UNSAFE_RAW. These
  can be exploited when magic_quotes_gpc settings is disabled.

  Impact:
  Successful exploitation could allow attackers to inject SQL code in the
  affected user application, and this may lead to other attacks also.

  Impact Level: Application

  Affected Software/OS:
  PHP, PHP version 5.2.7 on all running platform.

  Fix: Upgrade to higher version,
  http://www.php.net/downloads.php

  References:
  http://bugs.php.net/bug.php?id=42718
  http://www.php.net/archive/2008.php#id2008-12-08-1
  http://web.nvd.nist.gov/view/vuln/detail?vulnId=CVE-2008-5844

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.5
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}

# Check PHP version 5.2.7
if(phpVer =~ "5.2.7"){
  security_hole(phpPort);
}
