###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_php_mult_vuln_dec09.nasl 5956 2009-12-02 18:42:56Z dec $
#
# PHP Multiple Vulnerabilities Dec-09
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801060);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2009-4018","CVE-2009-2626");
  script_bugtraq_id(37138, 36009);
  script_name("PHP Multiple Vulnerabilities Dec-09");
  desc = "
  Overview: This host is running PHP and is prone to multiple vulnerabilities.

  Vulnerability Insight:
  Multiple flaws are due to:
   - Error in 'proc_open()' function in 'ext/standard/proc_open.c' that does not
     enforce the 'safe_mode_allowed_env_vars' and 'safe_mode_protected_env_vars'
     directives, which allows attackers to execute programs with an arbitrary
     environment via the env parameter.
   - Error in 'zend_restore_ini_entry_cb()' function in 'zend_ini.c', which
     allows attackers to obtain sensitive information.

  Impact:
  Successful exploitation could allow local attackers to bypass certain
  security restrictions and cause denial of service.

  Impact Level: Network

  Affected Software/OS:
  PHP version 5.2.10 and prior.
  PHP version 5.3.x before 5.3.1

  Fix: Upgrade to PHP version 5.3.1
  http://www.php.net/downloads.php

  References:
  http://secunia.com/advisories/37482
  http://bugs.php.net/bug.php?id=49026
  http://securityreason.com/achievement_securityalert/65
  http://www.openwall.com/lists/oss-security/2009/11/23/15

  CVSS Score:
    CVSS Base Score     : 7.5 (AV:N/AC:L/Au:NR/C:P/I:P/A:P)
    CVSS Temporal Score : 5.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("version_func.inc");

phpPort = get_kb_item("Services/www");
if(!phpPort)
{
  phpPort = 80;
  if(!get_port_state(phpPort)){
    exit(0);
  }
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}

if(version_is_less(version:phpVer, test_version:"5.2.11")){
  security_hole(port: phpPort);
  exit(0);
}

else if(phpVer =~ "^5\.3")
{
  if(version_is_less(version:phpVer, test_version:"5.3.1")){
   security_hole(port: phpPort);
  }
}
