###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_php_display_errors_xss_vuln.nasl 808 2009-01-07 13:45:56Z jan $
#
# PHP display_errors Cross-Site Scripting Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800334);
  script_version("$Revision: 1.0 $");
  script_cve_id("CVE-2008-5814");
  script_name("PHP display_errors Cross-Site Scripting Vulnerability");
  desc = "

  Overview: The host is running PHP and is prone to Cross-Site Scripting
  vulnerability.

  Vulnerability Insight:
  The flaw is caused due to improper handling of certain inputs when
  display_errors settings is enabled.

  Impact:
  Successful exploitation could allow attackers to inject arbitrary web script
  or HTML via unspecified vectors and conduct Cross-Site Scripting attacks.

  Impact Level: Application

  Affected Software/OS:
  PHP, PHP version 5.2.7 and prior on all running platform.

  Fix: Upgrade to version 5.2.8 or later
  http://www.php.net/downloads.php

  References:
  http://jvn.jp/en/jp/JVN50327700/index.html
  http://jvndb.jvn.jp/en/contents/2008/JVNDB-2008-000084.html

  CVSS Score:
    CVSS Base Score     : 2.6 (AV:N/AC:H/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 1.9
  Risk factor : Low";

  script_description(desc);
  script_summary("Check for the version of PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_php_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

phpPort = get_http_port(default:80);
if(!phpPort){
  exit(0);
}

phpVer = get_kb_item("www/" + phpPort + "/PHP");
if(!phpVer){
  exit(0);
}

# Check PHP version 5.2.7 and prior
if(version_is_less_equal(version:phpVer, test_version:"5.2.7")){
  security_warning(phpPort);
}
